/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.GwtCompatible;
import org.python.google.common.base.Ascii;
import org.python.google.common.base.CharMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher charMatcher, String string2) {
        this.wordBoundary = charMatcher;
        this.wordSeparator = string2;
    }

    public String to(CaseFormat caseFormat, String string) {
        if (caseFormat == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (caseFormat == this) {
            return string;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (caseFormat) {
                    case LOWER_UNDERSCORE: {
                        return string.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(string.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return string.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(string);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return Ascii.toLowerCase(string.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return Ascii.toLowerCase(string);
                    }
                }
            }
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = this.wordBoundary.indexIn(string, n2)) == -1) break;
            if (n == 0) {
                stringBuilder = new StringBuilder(string.length() + 4 * this.wordSeparator.length());
                stringBuilder.append(caseFormat.normalizeFirstWord(string.substring(n, n2)));
            } else {
                stringBuilder.append(caseFormat.normalizeWord(string.substring(n, n2)));
            }
            stringBuilder.append(caseFormat.wordSeparator);
            n = n2 + this.wordSeparator.length();
        }
        if (n == 0) {
            return caseFormat.normalizeFirstWord(string);
        }
        stringBuilder.append(caseFormat.normalizeWord(string.substring(n)));
        return stringBuilder.toString();
    }

    private String normalizeFirstWord(String string) {
        switch (this) {
            case LOWER_CAMEL: {
                return Ascii.toLowerCase(string);
            }
        }
        return this.normalizeWord(string);
    }

    private String normalizeWord(String string) {
        switch (this) {
            case LOWER_HYPHEN: {
                return Ascii.toLowerCase(string);
            }
            case LOWER_UNDERSCORE: {
                return Ascii.toLowerCase(string);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(string);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(string);
            }
            case UPPER_UNDERSCORE: {
                return Ascii.toUpperCase(string);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        return new StringBuilder(n).append(Ascii.toUpperCase(string.charAt(0))).append(Ascii.toLowerCase(string.substring(1))).toString();
    }
}

